#include "LPC15xx.h"

extern void SCT1_Init(void);

#define hperiod    (180)

void SysTick_Handler(void)
{
    LPC_SCT1->CONFIG |= (1 << 7);                      // stop reload process for L counter

    if (LPC_GPIO->PIN[2] & (1 << 5))                   // P2_5 high?
    {
        if (LPC_SCT1->MATCHREL[2].L < hperiod-1)        // check if DC2 < Period of PWM
        {
            LPC_SCT1->MATCHREL[1].L ++;
            LPC_SCT1->MATCHREL[2].L ++;
        }
    }
    else if (LPC_SCT1->MATCHREL[1].L > 1)              // check if DC1 > 1
    {
        LPC_SCT1->MATCHREL[1].L --;
        LPC_SCT1->MATCHREL[2].L --;
    }
    LPC_SCT1->CONFIG &= ~(1 << 7);                     // enable reload process for L counter
}

int main (void)
{
    LPC_SYSCON->SYSAHBCLKCTRL0  |= EN0_SWM    |        // enable SWM clock
                                   EN0_GPIO2  |        // enable GPIO2 port clock
                                   EN0_IOCON;          // enable IOCON clock

    LPC_SWM->PINASSIGN8         |= 0x0000FFFF;         // ASSIGN8(15:0) = FFFF
    LPC_SWM->PINASSIGN8         &= 0xFFFF0001;         // SCT1_OUT0 = P0.1 = blue LED
                                                       // SCT1_OUT1 = P0.0 = red LED
    SysTick_Config(SystemCoreClock/50);                // SysTick interrupt @ 50 Hz = 20 msec
    SCT1_Init();                                       // Initialize SCT0

    while (1)                                          // loop forever
    {
    }
}
